/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : 
FUNCTION       : SYNCHRONOUS UP/DOWN 4-BIT BINARY COUNTERS
TRUTHTABLE     : 

+--------------------------------+-----------------------+
|             INPUTS             |                       |
+--------------------------------+       OPERATION       |
|  LOAD_ ENT_  ENP_   UD_   CLK  |                       |
+--------------------------------+-----------------------+
|                            _   |                       |
|   L     X     X     X    _/    |   LOAD PARRALLEL DATA |
|                            _   |                       |
|   H     L     L     H    _/    |   BINARY COUNT UP     |
|                            _   |                       |
|   H     L     L     L    _/    |   BINARY COUNT DOWN   |
|                                |                       |
|   H     H     X     X     X    |   INHIBIT COUNTING    |
|                                |                       |
|   H     X     H     X     X    |   INHIBIT COUNTING    |
+--------------------------------+-----------------------+

     NOTE : RCO_ GOES LOW AT THE TERMINAL COUNT FOR THE 
            DURATION OF ONE CLOCK PULSE.
                  
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a169 (updn, clk, a, b, c, d, enpn, ldn, entn, qd, qc, qb, qa, rcon);
	parameter size =1;
	parameter cds_action = "ignore";
	input
		updn,
		clk,
		a,
		b,
		c,
		d,
		enpn,
		ldn,
		entn;
	output
		qd,
		qc,
		qb,
		qa,
		rcon;
    reg
        NOTIFY_REG;
    not
	  (load, ldn);
    not
	  (enp, enpn);
    not
	  (ent, entn);
    and
	  (en1, ent, ldn);
    and
	  (en2, enp, ldn);
    and
	  (en3, ent, enp, ldn);
    not
	M169N_inst_I1 (m169n_inst_wi1, updn);
    not
	M169N_inst_I2 (m169n_inst_wi2, entn);
    not
	M169N_inst_I3 (m169n_inst_wi3, ldn);
    nor
	M169N_inst_NO1 (m169n_inst_wno1, enpn, entn, m169n_inst_wi3);
    nor  
	M169N_inst_NO6 (rcon, m169n_inst_wa20, m169n_inst_wa21);
    xor
	M169N_inst_XO1 (m169n_inst_wxo1, m169n_inst_wa1, m169n_inst_wno1);
    and
	M169N_inst_A1 (m169n_inst_wa1, m169n_inst_qaint, ldn);
    and
	M169N_inst_A20 (m169n_inst_wa20, m169n_inst_wno5, m169n_inst_wno4, m169n_inst_wno3, m169n_inst_wno2, m169n_inst_wi2);
    and
	M169N_inst_A21 (m169n_inst_wa21, m169n_inst_wi1, m169n_inst_wi2, m169n_inst_wno2, m169n_inst_wno3, m169n_inst_wno4, m169n_inst_wno5);
    not
	  (m169n_inst_wqna, m169n_inst_qaint);
    not
	  (m169n_inst_wqnb, m169n_inst_qbint);
    not
	  (m169n_inst_wqnc, m169n_inst_qcint);
    not
	  (m169n_inst_wqnd, m169n_inst_qdint);
    buf  
	  (qa, m169n_inst_qaint);
    buf  
	  (qb, m169n_inst_qbint);
    buf  
	  (qc, m169n_inst_qcint);
    buf  
	  (qd, m169n_inst_qdint);
    U_AO_3
	M169N_inst_inst1_inst1 (m169n_inst_wo1, m169n_inst_wxo1, a, m169n_inst_wi3);
    U_AO_3
	M169N_inst_inst2_inst1 (m169n_inst_wo2, m169n_inst_wxo2, b, m169n_inst_wi3);
    U_AO_3
	M169N_inst_inst3_inst1 (m169n_inst_wo3, m169n_inst_wxo3, c, m169n_inst_wi3);
    U_AO_3
	M169N_inst_inst4_inst1 (m169n_inst_wo4, m169n_inst_wxo4, d, m169n_inst_wi3);
    U_AOI_2_2
	M169N_inst_inst5_inst1 (m169n_inst_wno2, updn, m169n_inst_wqna, m169n_inst_wi1, m169n_inst_qaint);
    U_AOI_2_2
	M169N_inst_inst6_inst1 (m169n_inst_wno3, updn, m169n_inst_wqnb, m169n_inst_wi1, m169n_inst_qbint);
    U_AOI_2_2
	M169N_inst_inst7_inst1 (m169n_inst_wno4, updn, m169n_inst_wqnc, m169n_inst_wi1, m169n_inst_qcint);
    U_AOI_2_2
	M169N_inst_inst8_inst1 (m169n_inst_wno5, updn, m169n_inst_wqnd, m169n_inst_wi1, m169n_inst_qdint);
    U_AXO_2_2
	M169N_inst_inst9_inst1 (m169n_inst_wxo2, m169n_inst_qbint, ldn, m169n_inst_wno1, m169n_inst_wno2);
    U_AXO_2_3
	M169N_inst_inst10_inst1 (m169n_inst_wxo3, m169n_inst_qcint, ldn, m169n_inst_wno1, m169n_inst_wno2, m169n_inst_wno3);
    U_AXO_2_4
	M169N_inst_inst11_inst1 (m169n_inst_wxo4, m169n_inst_qdint, ldn, m169n_inst_wno1, m169n_inst_wno2, m169n_inst_wno3, m169n_inst_wno4);
    U_FD_P_NO
	M169N_inst_FF1_inst1 (m169n_inst_qaint, m169n_inst_wo1, clk, NOTIFY_REG);
    U_FD_P_NO
	M169N_inst_FF2_inst1 (m169n_inst_qbint, m169n_inst_wo2, clk, NOTIFY_REG);
    U_FD_P_NO
	M169N_inst_FF3_inst1 (m169n_inst_qcint, m169n_inst_wo3, clk, NOTIFY_REG);
    U_FD_P_NO
	M169N_inst_FF4_inst1 (m169n_inst_qdint, m169n_inst_wo4, clk, NOTIFY_REG);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
